package zio.aws.sfn.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.{PageToken, PageSize, Arn}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListMapRunsRequest(
    executionArn: Arn,
    maxResults: Optional[PageSize] = Optional.Absent,
    nextToken: Optional[PageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.ListMapRunsRequest = {
    import ListMapRunsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.ListMapRunsRequest
      .builder()
      .executionArn(Arn.unwrap(executionArn): java.lang.String)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(
        nextToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.ListMapRunsRequest.ReadOnly =
    zio.aws.sfn.model.ListMapRunsRequest.wrap(buildAwsValue())
}
object ListMapRunsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.ListMapRunsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.ListMapRunsRequest =
      zio.aws.sfn.model.ListMapRunsRequest(
        executionArn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def executionArn: Arn
    def maxResults: Optional[PageSize]
    def nextToken: Optional[PageToken]
    def getExecutionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(executionArn)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.ListMapRunsRequest
  ) extends zio.aws.sfn.model.ListMapRunsRequest.ReadOnly {
    override val executionArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.executionArn())
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sfn.model.primitives.PageSize(value))
    override val nextToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sfn.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.ListMapRunsRequest
  ): zio.aws.sfn.model.ListMapRunsRequest.ReadOnly = new Wrapper(impl)
}
