package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.PageToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListMapRunsResponse(
    mapRuns: Iterable[zio.aws.sfn.model.MapRunListItem],
    nextToken: Optional[PageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.ListMapRunsResponse = {
    import ListMapRunsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.ListMapRunsResponse
      .builder()
      .mapRuns(mapRuns.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.ListMapRunsResponse.ReadOnly =
    zio.aws.sfn.model.ListMapRunsResponse.wrap(buildAwsValue())
}
object ListMapRunsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.ListMapRunsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.ListMapRunsResponse =
      zio.aws.sfn.model.ListMapRunsResponse(
        mapRuns.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def mapRuns: List[zio.aws.sfn.model.MapRunListItem.ReadOnly]
    def nextToken: Optional[PageToken]
    def getMapRuns
        : ZIO[Any, Nothing, List[zio.aws.sfn.model.MapRunListItem.ReadOnly]] =
      ZIO.succeed(mapRuns)
    def getNextToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.ListMapRunsResponse
  ) extends zio.aws.sfn.model.ListMapRunsResponse.ReadOnly {
    override val mapRuns: List[zio.aws.sfn.model.MapRunListItem.ReadOnly] = impl
      .mapRuns()
      .asScala
      .map { item =>
        zio.aws.sfn.model.MapRunListItem.wrap(item)
      }
      .toList
    override val nextToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sfn.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.ListMapRunsResponse
  ): zio.aws.sfn.model.ListMapRunsResponse.ReadOnly = new Wrapper(impl)
}
