package zio.aws.sfn.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.{PageSize, PageToken, Arn}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListStateMachineAliasesRequest(
    stateMachineArn: Arn,
    nextToken: Optional[PageToken] = Optional.Absent,
    maxResults: Optional[PageSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.ListStateMachineAliasesRequest = {
    import ListStateMachineAliasesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.ListStateMachineAliasesRequest
      .builder()
      .stateMachineArn(Arn.unwrap(stateMachineArn): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.ListStateMachineAliasesRequest.ReadOnly =
    zio.aws.sfn.model.ListStateMachineAliasesRequest.wrap(buildAwsValue())
}
object ListStateMachineAliasesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.ListStateMachineAliasesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.ListStateMachineAliasesRequest =
      zio.aws.sfn.model.ListStateMachineAliasesRequest(
        stateMachineArn,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def stateMachineArn: Arn
    def nextToken: Optional[PageToken]
    def maxResults: Optional[PageSize]
    def getStateMachineArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(stateMachineArn)
    def getNextToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.ListStateMachineAliasesRequest
  ) extends zio.aws.sfn.model.ListStateMachineAliasesRequest.ReadOnly {
    override val stateMachineArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.stateMachineArn())
    override val nextToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sfn.model.primitives.PageToken(value))
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sfn.model.primitives.PageSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.ListStateMachineAliasesRequest
  ): zio.aws.sfn.model.ListStateMachineAliasesRequest.ReadOnly = new Wrapper(
    impl
  )
}
