package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.PageToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStateMachineAliasesResponse(
    stateMachineAliases: Iterable[zio.aws.sfn.model.StateMachineAliasListItem],
    nextToken: Optional[PageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.ListStateMachineAliasesResponse = {
    import ListStateMachineAliasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.ListStateMachineAliasesResponse
      .builder()
      .stateMachineAliases(stateMachineAliases.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.ListStateMachineAliasesResponse.ReadOnly =
    zio.aws.sfn.model.ListStateMachineAliasesResponse.wrap(buildAwsValue())
}
object ListStateMachineAliasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.ListStateMachineAliasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.ListStateMachineAliasesResponse =
      zio.aws.sfn.model.ListStateMachineAliasesResponse(
        stateMachineAliases.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def stateMachineAliases
        : List[zio.aws.sfn.model.StateMachineAliasListItem.ReadOnly]
    def nextToken: Optional[PageToken]
    def getStateMachineAliases: ZIO[Any, Nothing, List[
      zio.aws.sfn.model.StateMachineAliasListItem.ReadOnly
    ]] = ZIO.succeed(stateMachineAliases)
    def getNextToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.ListStateMachineAliasesResponse
  ) extends zio.aws.sfn.model.ListStateMachineAliasesResponse.ReadOnly {
    override val stateMachineAliases
        : List[zio.aws.sfn.model.StateMachineAliasListItem.ReadOnly] = impl
      .stateMachineAliases()
      .asScala
      .map { item =>
        zio.aws.sfn.model.StateMachineAliasListItem.wrap(item)
      }
      .toList
    override val nextToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sfn.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.ListStateMachineAliasesResponse
  ): zio.aws.sfn.model.ListStateMachineAliasesResponse.ReadOnly = new Wrapper(
    impl
  )
}
