package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.PageToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStateMachineVersionsResponse(
    stateMachineVersions: Iterable[
      zio.aws.sfn.model.StateMachineVersionListItem
    ],
    nextToken: Optional[PageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.ListStateMachineVersionsResponse = {
    import ListStateMachineVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.ListStateMachineVersionsResponse
      .builder()
      .stateMachineVersions(stateMachineVersions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.ListStateMachineVersionsResponse.ReadOnly =
    zio.aws.sfn.model.ListStateMachineVersionsResponse.wrap(buildAwsValue())
}
object ListStateMachineVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.ListStateMachineVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.ListStateMachineVersionsResponse =
      zio.aws.sfn.model.ListStateMachineVersionsResponse(
        stateMachineVersions.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def stateMachineVersions
        : List[zio.aws.sfn.model.StateMachineVersionListItem.ReadOnly]
    def nextToken: Optional[PageToken]
    def getStateMachineVersions: ZIO[Any, Nothing, List[
      zio.aws.sfn.model.StateMachineVersionListItem.ReadOnly
    ]] = ZIO.succeed(stateMachineVersions)
    def getNextToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.ListStateMachineVersionsResponse
  ) extends zio.aws.sfn.model.ListStateMachineVersionsResponse.ReadOnly {
    override val stateMachineVersions
        : List[zio.aws.sfn.model.StateMachineVersionListItem.ReadOnly] = impl
      .stateMachineVersions()
      .asScala
      .map { item =>
        zio.aws.sfn.model.StateMachineVersionListItem.wrap(item)
      }
      .toList
    override val nextToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sfn.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.ListStateMachineVersionsResponse
  ): zio.aws.sfn.model.ListStateMachineVersionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
