package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.PageToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStateMachinesResponse(
    stateMachines: Iterable[zio.aws.sfn.model.StateMachineListItem],
    nextToken: Optional[PageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.ListStateMachinesResponse = {
    import ListStateMachinesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.ListStateMachinesResponse
      .builder()
      .stateMachines(stateMachines.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.ListStateMachinesResponse.ReadOnly =
    zio.aws.sfn.model.ListStateMachinesResponse.wrap(buildAwsValue())
}
object ListStateMachinesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.ListStateMachinesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.ListStateMachinesResponse =
      zio.aws.sfn.model.ListStateMachinesResponse(
        stateMachines.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def stateMachines: List[zio.aws.sfn.model.StateMachineListItem.ReadOnly]
    def nextToken: Optional[PageToken]
    def getStateMachines: ZIO[Any, Nothing, List[
      zio.aws.sfn.model.StateMachineListItem.ReadOnly
    ]] = ZIO.succeed(stateMachines)
    def getNextToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.ListStateMachinesResponse
  ) extends zio.aws.sfn.model.ListStateMachinesResponse.ReadOnly {
    override val stateMachines
        : List[zio.aws.sfn.model.StateMachineListItem.ReadOnly] = impl
      .stateMachines()
      .asScala
      .map { item =>
        zio.aws.sfn.model.StateMachineListItem.wrap(item)
      }
      .toList
    override val nextToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sfn.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.ListStateMachinesResponse
  ): zio.aws.sfn.model.ListStateMachinesResponse.ReadOnly = new Wrapper(impl)
}
