package zio.aws.sfn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LogDestination(
    cloudWatchLogsLogGroup: Optional[zio.aws.sfn.model.CloudWatchLogsLogGroup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.LogDestination = {
    import LogDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.LogDestination
      .builder()
      .optionallyWith(
        cloudWatchLogsLogGroup.map(value => value.buildAwsValue())
      )(_.cloudWatchLogsLogGroup)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.LogDestination.ReadOnly =
    zio.aws.sfn.model.LogDestination.wrap(buildAwsValue())
}
object LogDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.LogDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.LogDestination = zio.aws.sfn.model
      .LogDestination(cloudWatchLogsLogGroup.map(value => value.asEditable))
    def cloudWatchLogsLogGroup
        : Optional[zio.aws.sfn.model.CloudWatchLogsLogGroup.ReadOnly]
    def getCloudWatchLogsLogGroup: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.CloudWatchLogsLogGroup.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLogsLogGroup",
      cloudWatchLogsLogGroup
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.LogDestination
  ) extends zio.aws.sfn.model.LogDestination.ReadOnly {
    override val cloudWatchLogsLogGroup
        : Optional[zio.aws.sfn.model.CloudWatchLogsLogGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLogsLogGroup())
        .map(value => zio.aws.sfn.model.CloudWatchLogsLogGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.LogDestination
  ): zio.aws.sfn.model.LogDestination.ReadOnly = new Wrapper(impl)
}
