package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.IncludeExecutionData
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LoggingConfiguration(
    level: Optional[zio.aws.sfn.model.LogLevel] = Optional.Absent,
    includeExecutionData: Optional[IncludeExecutionData] = Optional.Absent,
    destinations: Optional[Iterable[zio.aws.sfn.model.LogDestination]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.LoggingConfiguration = {
    import LoggingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.LoggingConfiguration
      .builder()
      .optionallyWith(level.map(value => value.unwrap))(_.level)
      .optionallyWith(
        includeExecutionData.map(value =>
          IncludeExecutionData.unwrap(value): java.lang.Boolean
        )
      )(_.includeExecutionData)
      .optionallyWith(
        destinations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinations)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.LoggingConfiguration.ReadOnly =
    zio.aws.sfn.model.LoggingConfiguration.wrap(buildAwsValue())
}
object LoggingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.LoggingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.LoggingConfiguration =
      zio.aws.sfn.model.LoggingConfiguration(
        level.map(value => value),
        includeExecutionData.map(value => value),
        destinations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def level: Optional[zio.aws.sfn.model.LogLevel]
    def includeExecutionData: Optional[IncludeExecutionData]
    def destinations: Optional[List[zio.aws.sfn.model.LogDestination.ReadOnly]]
    def getLevel: ZIO[Any, AwsError, zio.aws.sfn.model.LogLevel] =
      AwsError.unwrapOptionField("level", level)
    def getIncludeExecutionData: ZIO[Any, AwsError, IncludeExecutionData] =
      AwsError.unwrapOptionField("includeExecutionData", includeExecutionData)
    def getDestinations
        : ZIO[Any, AwsError, List[zio.aws.sfn.model.LogDestination.ReadOnly]] =
      AwsError.unwrapOptionField("destinations", destinations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.LoggingConfiguration
  ) extends zio.aws.sfn.model.LoggingConfiguration.ReadOnly {
    override val level: Optional[zio.aws.sfn.model.LogLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.level())
        .map(value => zio.aws.sfn.model.LogLevel.wrap(value))
    override val includeExecutionData: Optional[IncludeExecutionData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeExecutionData())
        .map(value => zio.aws.sfn.model.primitives.IncludeExecutionData(value))
    override val destinations
        : Optional[List[zio.aws.sfn.model.LogDestination.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sfn.model.LogDestination.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.LoggingConfiguration
  ): zio.aws.sfn.model.LoggingConfiguration.ReadOnly = new Wrapper(impl)
}
