package zio.aws.sfn.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.{UnsignedInteger, Name}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class MapIterationEventDetails(
    name: Optional[Name] = Optional.Absent,
    index: Optional[UnsignedInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.MapIterationEventDetails = {
    import MapIterationEventDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.MapIterationEventDetails
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        index.map(value => UnsignedInteger.unwrap(value): Integer)
      )(_.index)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.MapIterationEventDetails.ReadOnly =
    zio.aws.sfn.model.MapIterationEventDetails.wrap(buildAwsValue())
}
object MapIterationEventDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.MapIterationEventDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.MapIterationEventDetails =
      zio.aws.sfn.model.MapIterationEventDetails(
        name.map(value => value),
        index.map(value => value)
      )
    def name: Optional[Name]
    def index: Optional[UnsignedInteger]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getIndex: ZIO[Any, AwsError, UnsignedInteger] =
      AwsError.unwrapOptionField("index", index)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.MapIterationEventDetails
  ) extends zio.aws.sfn.model.MapIterationEventDetails.ReadOnly {
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.sfn.model.primitives.Name(value))
    override val index: Optional[UnsignedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.index())
      .map(value => zio.aws.sfn.model.primitives.UnsignedInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.MapIterationEventDetails
  ): zio.aws.sfn.model.MapIterationEventDetails.ReadOnly = new Wrapper(impl)
}
