package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{LongObject, UnsignedLong}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MapRunExecutionCounts(
    pending: UnsignedLong,
    running: UnsignedLong,
    succeeded: UnsignedLong,
    failed: UnsignedLong,
    timedOut: UnsignedLong,
    aborted: UnsignedLong,
    total: UnsignedLong,
    resultsWritten: UnsignedLong,
    failuresNotRedrivable: Optional[LongObject] = Optional.Absent,
    pendingRedrive: Optional[LongObject] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.MapRunExecutionCounts = {
    import MapRunExecutionCounts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.MapRunExecutionCounts
      .builder()
      .pending(UnsignedLong.unwrap(pending): java.lang.Long)
      .running(UnsignedLong.unwrap(running): java.lang.Long)
      .succeeded(UnsignedLong.unwrap(succeeded): java.lang.Long)
      .failed(UnsignedLong.unwrap(failed): java.lang.Long)
      .timedOut(UnsignedLong.unwrap(timedOut): java.lang.Long)
      .aborted(UnsignedLong.unwrap(aborted): java.lang.Long)
      .total(UnsignedLong.unwrap(total): java.lang.Long)
      .resultsWritten(UnsignedLong.unwrap(resultsWritten): java.lang.Long)
      .optionallyWith(
        failuresNotRedrivable.map(value => value: java.lang.Long)
      )(_.failuresNotRedrivable)
      .optionallyWith(pendingRedrive.map(value => value: java.lang.Long))(
        _.pendingRedrive
      )
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.MapRunExecutionCounts.ReadOnly =
    zio.aws.sfn.model.MapRunExecutionCounts.wrap(buildAwsValue())
}
object MapRunExecutionCounts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.MapRunExecutionCounts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.MapRunExecutionCounts =
      zio.aws.sfn.model.MapRunExecutionCounts(
        pending,
        running,
        succeeded,
        failed,
        timedOut,
        aborted,
        total,
        resultsWritten,
        failuresNotRedrivable.map(value => value),
        pendingRedrive.map(value => value)
      )
    def pending: UnsignedLong
    def running: UnsignedLong
    def succeeded: UnsignedLong
    def failed: UnsignedLong
    def timedOut: UnsignedLong
    def aborted: UnsignedLong
    def total: UnsignedLong
    def resultsWritten: UnsignedLong
    def failuresNotRedrivable: Optional[LongObject]
    def pendingRedrive: Optional[LongObject]
    def getPending: ZIO[Any, Nothing, UnsignedLong] = ZIO.succeed(pending)
    def getRunning: ZIO[Any, Nothing, UnsignedLong] = ZIO.succeed(running)
    def getSucceeded: ZIO[Any, Nothing, UnsignedLong] = ZIO.succeed(succeeded)
    def getFailed: ZIO[Any, Nothing, UnsignedLong] = ZIO.succeed(failed)
    def getTimedOut: ZIO[Any, Nothing, UnsignedLong] = ZIO.succeed(timedOut)
    def getAborted: ZIO[Any, Nothing, UnsignedLong] = ZIO.succeed(aborted)
    def getTotal: ZIO[Any, Nothing, UnsignedLong] = ZIO.succeed(total)
    def getResultsWritten: ZIO[Any, Nothing, UnsignedLong] =
      ZIO.succeed(resultsWritten)
    def getFailuresNotRedrivable: ZIO[Any, AwsError, LongObject] =
      AwsError.unwrapOptionField("failuresNotRedrivable", failuresNotRedrivable)
    def getPendingRedrive: ZIO[Any, AwsError, LongObject] =
      AwsError.unwrapOptionField("pendingRedrive", pendingRedrive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.MapRunExecutionCounts
  ) extends zio.aws.sfn.model.MapRunExecutionCounts.ReadOnly {
    override val pending: UnsignedLong =
      zio.aws.sfn.model.primitives.UnsignedLong(impl.pending())
    override val running: UnsignedLong =
      zio.aws.sfn.model.primitives.UnsignedLong(impl.running())
    override val succeeded: UnsignedLong =
      zio.aws.sfn.model.primitives.UnsignedLong(impl.succeeded())
    override val failed: UnsignedLong =
      zio.aws.sfn.model.primitives.UnsignedLong(impl.failed())
    override val timedOut: UnsignedLong =
      zio.aws.sfn.model.primitives.UnsignedLong(impl.timedOut())
    override val aborted: UnsignedLong =
      zio.aws.sfn.model.primitives.UnsignedLong(impl.aborted())
    override val total: UnsignedLong =
      zio.aws.sfn.model.primitives.UnsignedLong(impl.total())
    override val resultsWritten: UnsignedLong =
      zio.aws.sfn.model.primitives.UnsignedLong(impl.resultsWritten())
    override val failuresNotRedrivable: Optional[LongObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failuresNotRedrivable())
        .map(value => value: LongObject)
    override val pendingRedrive: Optional[LongObject] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingRedrive())
      .map(value => value: LongObject)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.MapRunExecutionCounts
  ): zio.aws.sfn.model.MapRunExecutionCounts.ReadOnly = new Wrapper(impl)
}
