package zio.aws.sfn.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.{Timestamp, LongArn, Arn}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class MapRunListItem(
    executionArn: Arn,
    mapRunArn: LongArn,
    stateMachineArn: Arn,
    startDate: Timestamp,
    stopDate: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.MapRunListItem = {
    import MapRunListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.MapRunListItem
      .builder()
      .executionArn(Arn.unwrap(executionArn): java.lang.String)
      .mapRunArn(LongArn.unwrap(mapRunArn): java.lang.String)
      .stateMachineArn(Arn.unwrap(stateMachineArn): java.lang.String)
      .startDate(Timestamp.unwrap(startDate): Instant)
      .optionallyWith(stopDate.map(value => Timestamp.unwrap(value): Instant))(
        _.stopDate
      )
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.MapRunListItem.ReadOnly =
    zio.aws.sfn.model.MapRunListItem.wrap(buildAwsValue())
}
object MapRunListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.MapRunListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.MapRunListItem =
      zio.aws.sfn.model.MapRunListItem(
        executionArn,
        mapRunArn,
        stateMachineArn,
        startDate,
        stopDate.map(value => value)
      )
    def executionArn: Arn
    def mapRunArn: LongArn
    def stateMachineArn: Arn
    def startDate: Timestamp
    def stopDate: Optional[Timestamp]
    def getExecutionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(executionArn)
    def getMapRunArn: ZIO[Any, Nothing, LongArn] = ZIO.succeed(mapRunArn)
    def getStateMachineArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(stateMachineArn)
    def getStartDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startDate)
    def getStopDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("stopDate", stopDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.MapRunListItem
  ) extends zio.aws.sfn.model.MapRunListItem.ReadOnly {
    override val executionArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.executionArn())
    override val mapRunArn: LongArn =
      zio.aws.sfn.model.primitives.LongArn(impl.mapRunArn())
    override val stateMachineArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.stateMachineArn())
    override val startDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.startDate())
    override val stopDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.stopDate())
      .map(value => zio.aws.sfn.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.MapRunListItem
  ): zio.aws.sfn.model.MapRunListItem.ReadOnly = new Wrapper(impl)
}
