package zio.aws.sfn.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.{RedriveCount, LongArn}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class MapRunRedrivenEventDetails(
    mapRunArn: Optional[LongArn] = Optional.Absent,
    redriveCount: Optional[RedriveCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.MapRunRedrivenEventDetails = {
    import MapRunRedrivenEventDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.MapRunRedrivenEventDetails
      .builder()
      .optionallyWith(
        mapRunArn.map(value => LongArn.unwrap(value): java.lang.String)
      )(_.mapRunArn)
      .optionallyWith(
        redriveCount.map(value => RedriveCount.unwrap(value): Integer)
      )(_.redriveCount)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.MapRunRedrivenEventDetails.ReadOnly =
    zio.aws.sfn.model.MapRunRedrivenEventDetails.wrap(buildAwsValue())
}
object MapRunRedrivenEventDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.MapRunRedrivenEventDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.MapRunRedrivenEventDetails =
      zio.aws.sfn.model.MapRunRedrivenEventDetails(
        mapRunArn.map(value => value),
        redriveCount.map(value => value)
      )
    def mapRunArn: Optional[LongArn]
    def redriveCount: Optional[RedriveCount]
    def getMapRunArn: ZIO[Any, AwsError, LongArn] =
      AwsError.unwrapOptionField("mapRunArn", mapRunArn)
    def getRedriveCount: ZIO[Any, AwsError, RedriveCount] =
      AwsError.unwrapOptionField("redriveCount", redriveCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.MapRunRedrivenEventDetails
  ) extends zio.aws.sfn.model.MapRunRedrivenEventDetails.ReadOnly {
    override val mapRunArn: Optional[LongArn] = zio.aws.core.internal
      .optionalFromNullable(impl.mapRunArn())
      .map(value => zio.aws.sfn.model.primitives.LongArn(value))
    override val redriveCount: Optional[RedriveCount] = zio.aws.core.internal
      .optionalFromNullable(impl.redriveCount())
      .map(value => zio.aws.sfn.model.primitives.RedriveCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.MapRunRedrivenEventDetails
  ): zio.aws.sfn.model.MapRunRedrivenEventDetails.ReadOnly = new Wrapper(impl)
}
