package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.LongArn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MapRunStartedEventDetails(
    mapRunArn: Optional[LongArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.MapRunStartedEventDetails = {
    import MapRunStartedEventDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.MapRunStartedEventDetails
      .builder()
      .optionallyWith(
        mapRunArn.map(value => LongArn.unwrap(value): java.lang.String)
      )(_.mapRunArn)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.MapRunStartedEventDetails.ReadOnly =
    zio.aws.sfn.model.MapRunStartedEventDetails.wrap(buildAwsValue())
}
object MapRunStartedEventDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.MapRunStartedEventDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.MapRunStartedEventDetails =
      zio.aws.sfn.model.MapRunStartedEventDetails(mapRunArn.map(value => value))
    def mapRunArn: Optional[LongArn]
    def getMapRunArn: ZIO[Any, AwsError, LongArn] =
      AwsError.unwrapOptionField("mapRunArn", mapRunArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.MapRunStartedEventDetails
  ) extends zio.aws.sfn.model.MapRunStartedEventDetails.ReadOnly {
    override val mapRunArn: Optional[LongArn] = zio.aws.core.internal
      .optionalFromNullable(impl.mapRunArn())
      .map(value => zio.aws.sfn.model.primitives.LongArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.MapRunStartedEventDetails
  ): zio.aws.sfn.model.MapRunStartedEventDetails.ReadOnly = new Wrapper(impl)
}
