package zio.aws.sfn.model
import scala.jdk.CollectionConverters._
sealed trait MapRunStatus {
  def unwrap: software.amazon.awssdk.services.sfn.model.MapRunStatus
}
object MapRunStatus {
  def wrap(
      value: software.amazon.awssdk.services.sfn.model.MapRunStatus
  ): zio.aws.sfn.model.MapRunStatus = value match {
    case software.amazon.awssdk.services.sfn.model.MapRunStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sfn.model.MapRunStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.sfn.model.MapRunStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.sfn.model.MapRunStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.sfn.model.MapRunStatus.ABORTED =>
      val r = ABORTED
      r
  }
  case object unknownToSdkVersion extends zio.aws.sfn.model.MapRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.MapRunStatus =
      software.amazon.awssdk.services.sfn.model.MapRunStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object RUNNING extends zio.aws.sfn.model.MapRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.MapRunStatus =
      software.amazon.awssdk.services.sfn.model.MapRunStatus.RUNNING
  }
  case object SUCCEEDED extends zio.aws.sfn.model.MapRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.MapRunStatus =
      software.amazon.awssdk.services.sfn.model.MapRunStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.sfn.model.MapRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.MapRunStatus =
      software.amazon.awssdk.services.sfn.model.MapRunStatus.FAILED
  }
  case object ABORTED extends zio.aws.sfn.model.MapRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.MapRunStatus =
      software.amazon.awssdk.services.sfn.model.MapRunStatus.ABORTED
  }
}
