package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{VersionDescription, RevisionId, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PublishStateMachineVersionRequest(
    stateMachineArn: Arn,
    revisionId: Optional[RevisionId] = Optional.Absent,
    description: Optional[VersionDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.PublishStateMachineVersionRequest = {
    import PublishStateMachineVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.PublishStateMachineVersionRequest
      .builder()
      .stateMachineArn(Arn.unwrap(stateMachineArn): java.lang.String)
      .optionallyWith(
        revisionId.map(value => RevisionId.unwrap(value): java.lang.String)
      )(_.revisionId)
      .optionallyWith(
        description.map(value =>
          VersionDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.PublishStateMachineVersionRequest.ReadOnly =
    zio.aws.sfn.model.PublishStateMachineVersionRequest.wrap(buildAwsValue())
}
object PublishStateMachineVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.PublishStateMachineVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.PublishStateMachineVersionRequest =
      zio.aws.sfn.model.PublishStateMachineVersionRequest(
        stateMachineArn,
        revisionId.map(value => value),
        description.map(value => value)
      )
    def stateMachineArn: Arn
    def revisionId: Optional[RevisionId]
    def description: Optional[VersionDescription]
    def getStateMachineArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(stateMachineArn)
    def getRevisionId: ZIO[Any, AwsError, RevisionId] =
      AwsError.unwrapOptionField("revisionId", revisionId)
    def getDescription: ZIO[Any, AwsError, VersionDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.PublishStateMachineVersionRequest
  ) extends zio.aws.sfn.model.PublishStateMachineVersionRequest.ReadOnly {
    override val stateMachineArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.stateMachineArn())
    override val revisionId: Optional[RevisionId] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionId())
      .map(value => zio.aws.sfn.model.primitives.RevisionId(value))
    override val description: Optional[VersionDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.sfn.model.primitives.VersionDescription(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.PublishStateMachineVersionRequest
  ): zio.aws.sfn.model.PublishStateMachineVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
