package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{Arn, Timestamp}
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class PublishStateMachineVersionResponse(
    creationDate: Timestamp,
    stateMachineVersionArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.PublishStateMachineVersionResponse = {
    import PublishStateMachineVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.PublishStateMachineVersionResponse
      .builder()
      .creationDate(Timestamp.unwrap(creationDate): Instant)
      .stateMachineVersionArn(
        Arn.unwrap(stateMachineVersionArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sfn.model.PublishStateMachineVersionResponse.ReadOnly =
    zio.aws.sfn.model.PublishStateMachineVersionResponse.wrap(buildAwsValue())
}
object PublishStateMachineVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.PublishStateMachineVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.PublishStateMachineVersionResponse =
      zio.aws.sfn.model.PublishStateMachineVersionResponse(
        creationDate,
        stateMachineVersionArn
      )
    def creationDate: Timestamp
    def stateMachineVersionArn: Arn
    def getCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDate)
    def getStateMachineVersionArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(stateMachineVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.PublishStateMachineVersionResponse
  ) extends zio.aws.sfn.model.PublishStateMachineVersionResponse.ReadOnly {
    override val creationDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.creationDate())
    override val stateMachineVersionArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.stateMachineVersionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.PublishStateMachineVersionResponse
  ): zio.aws.sfn.model.PublishStateMachineVersionResponse.ReadOnly =
    new Wrapper(impl)
}
