package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{ClientToken, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RedriveExecutionRequest(
    executionArn: Arn,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.RedriveExecutionRequest = {
    import RedriveExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.RedriveExecutionRequest
      .builder()
      .executionArn(Arn.unwrap(executionArn): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.RedriveExecutionRequest.ReadOnly =
    zio.aws.sfn.model.RedriveExecutionRequest.wrap(buildAwsValue())
}
object RedriveExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.RedriveExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.RedriveExecutionRequest =
      zio.aws.sfn.model
        .RedriveExecutionRequest(executionArn, clientToken.map(value => value))
    def executionArn: Arn
    def clientToken: Optional[ClientToken]
    def getExecutionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(executionArn)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.RedriveExecutionRequest
  ) extends zio.aws.sfn.model.RedriveExecutionRequest.ReadOnly {
    override val executionArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.executionArn())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.sfn.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.RedriveExecutionRequest
  ): zio.aws.sfn.model.RedriveExecutionRequest.ReadOnly = new Wrapper(impl)
}
