package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.Timestamp
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class RedriveExecutionResponse(redriveDate: Timestamp) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.RedriveExecutionResponse = {
    import RedriveExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.RedriveExecutionResponse
      .builder()
      .redriveDate(Timestamp.unwrap(redriveDate): Instant)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.RedriveExecutionResponse.ReadOnly =
    zio.aws.sfn.model.RedriveExecutionResponse.wrap(buildAwsValue())
}
object RedriveExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.RedriveExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.RedriveExecutionResponse =
      zio.aws.sfn.model.RedriveExecutionResponse(redriveDate)
    def redriveDate: Timestamp
    def getRedriveDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(redriveDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.RedriveExecutionResponse
  ) extends zio.aws.sfn.model.RedriveExecutionResponse.ReadOnly {
    override val redriveDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.redriveDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.RedriveExecutionResponse
  ): zio.aws.sfn.model.RedriveExecutionResponse.ReadOnly = new Wrapper(impl)
}
