package zio.aws.sfn.model
import java.lang.Integer
import zio.ZIO
import zio.aws.sfn.model.primitives.{VersionWeight, Arn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RoutingConfigurationListItem(
    stateMachineVersionArn: Arn,
    weight: VersionWeight
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.RoutingConfigurationListItem = {
    import RoutingConfigurationListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.RoutingConfigurationListItem
      .builder()
      .stateMachineVersionArn(
        Arn.unwrap(stateMachineVersionArn): java.lang.String
      )
      .weight(VersionWeight.unwrap(weight): Integer)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.RoutingConfigurationListItem.ReadOnly =
    zio.aws.sfn.model.RoutingConfigurationListItem.wrap(buildAwsValue())
}
object RoutingConfigurationListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.RoutingConfigurationListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.RoutingConfigurationListItem =
      zio.aws.sfn.model
        .RoutingConfigurationListItem(stateMachineVersionArn, weight)
    def stateMachineVersionArn: Arn
    def weight: VersionWeight
    def getStateMachineVersionArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(stateMachineVersionArn)
    def getWeight: ZIO[Any, Nothing, VersionWeight] = ZIO.succeed(weight)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.RoutingConfigurationListItem
  ) extends zio.aws.sfn.model.RoutingConfigurationListItem.ReadOnly {
    override val stateMachineVersionArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.stateMachineVersionArn())
    override val weight: VersionWeight =
      zio.aws.sfn.model.primitives.VersionWeight(impl.weight())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.RoutingConfigurationListItem
  ): zio.aws.sfn.model.RoutingConfigurationListItem.ReadOnly = new Wrapper(impl)
}
