package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{SensitiveData, TaskToken}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SendTaskSuccessRequest(
    taskToken: TaskToken,
    output: SensitiveData
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.SendTaskSuccessRequest = {
    import SendTaskSuccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.SendTaskSuccessRequest
      .builder()
      .taskToken(TaskToken.unwrap(taskToken): java.lang.String)
      .output(SensitiveData.unwrap(output): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.SendTaskSuccessRequest.ReadOnly =
    zio.aws.sfn.model.SendTaskSuccessRequest.wrap(buildAwsValue())
}
object SendTaskSuccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.SendTaskSuccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.SendTaskSuccessRequest =
      zio.aws.sfn.model.SendTaskSuccessRequest(taskToken, output)
    def taskToken: TaskToken
    def output: SensitiveData
    def getTaskToken: ZIO[Any, Nothing, TaskToken] = ZIO.succeed(taskToken)
    def getOutput: ZIO[Any, Nothing, SensitiveData] = ZIO.succeed(output)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.SendTaskSuccessRequest
  ) extends zio.aws.sfn.model.SendTaskSuccessRequest.ReadOnly {
    override val taskToken: TaskToken =
      zio.aws.sfn.model.primitives.TaskToken(impl.taskToken())
    override val output: SensitiveData =
      zio.aws.sfn.model.primitives.SensitiveData(impl.output())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.SendTaskSuccessRequest
  ): zio.aws.sfn.model.SendTaskSuccessRequest.ReadOnly = new Wrapper(impl)
}
