package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{TraceHeader, SensitiveData, Name, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartExecutionRequest(
    stateMachineArn: Arn,
    name: Optional[Name] = Optional.Absent,
    input: Optional[SensitiveData] = Optional.Absent,
    traceHeader: Optional[TraceHeader] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.StartExecutionRequest = {
    import StartExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.StartExecutionRequest
      .builder()
      .stateMachineArn(Arn.unwrap(stateMachineArn): java.lang.String)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        input.map(value => SensitiveData.unwrap(value): java.lang.String)
      )(_.input)
      .optionallyWith(
        traceHeader.map(value => TraceHeader.unwrap(value): java.lang.String)
      )(_.traceHeader)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.StartExecutionRequest.ReadOnly =
    zio.aws.sfn.model.StartExecutionRequest.wrap(buildAwsValue())
}
object StartExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.StartExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.StartExecutionRequest =
      zio.aws.sfn.model.StartExecutionRequest(
        stateMachineArn,
        name.map(value => value),
        input.map(value => value),
        traceHeader.map(value => value)
      )
    def stateMachineArn: Arn
    def name: Optional[Name]
    def input: Optional[SensitiveData]
    def traceHeader: Optional[TraceHeader]
    def getStateMachineArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(stateMachineArn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getInput: ZIO[Any, AwsError, SensitiveData] =
      AwsError.unwrapOptionField("input", input)
    def getTraceHeader: ZIO[Any, AwsError, TraceHeader] =
      AwsError.unwrapOptionField("traceHeader", traceHeader)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.StartExecutionRequest
  ) extends zio.aws.sfn.model.StartExecutionRequest.ReadOnly {
    override val stateMachineArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.stateMachineArn())
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.sfn.model.primitives.Name(value))
    override val input: Optional[SensitiveData] = zio.aws.core.internal
      .optionalFromNullable(impl.input())
      .map(value => zio.aws.sfn.model.primitives.SensitiveData(value))
    override val traceHeader: Optional[TraceHeader] = zio.aws.core.internal
      .optionalFromNullable(impl.traceHeader())
      .map(value => zio.aws.sfn.model.primitives.TraceHeader(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.StartExecutionRequest
  ): zio.aws.sfn.model.StartExecutionRequest.ReadOnly = new Wrapper(impl)
}
