package zio.aws.sfn.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.{
  Timestamp,
  SensitiveError,
  Arn,
  SensitiveCause,
  SensitiveData,
  TraceHeader,
  Name
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class StartSyncExecutionResponse(
    executionArn: Arn,
    stateMachineArn: Optional[Arn] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    startDate: Timestamp,
    stopDate: Timestamp,
    status: zio.aws.sfn.model.SyncExecutionStatus,
    error: Optional[SensitiveError] = Optional.Absent,
    cause: Optional[SensitiveCause] = Optional.Absent,
    input: Optional[SensitiveData] = Optional.Absent,
    inputDetails: Optional[
      zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails
    ] = Optional.Absent,
    output: Optional[SensitiveData] = Optional.Absent,
    outputDetails: Optional[
      zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails
    ] = Optional.Absent,
    traceHeader: Optional[TraceHeader] = Optional.Absent,
    billingDetails: Optional[zio.aws.sfn.model.BillingDetails] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.StartSyncExecutionResponse = {
    import StartSyncExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.StartSyncExecutionResponse
      .builder()
      .executionArn(Arn.unwrap(executionArn): java.lang.String)
      .optionallyWith(
        stateMachineArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.stateMachineArn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .startDate(Timestamp.unwrap(startDate): Instant)
      .stopDate(Timestamp.unwrap(stopDate): Instant)
      .status(status.unwrap)
      .optionallyWith(
        error.map(value => SensitiveError.unwrap(value): java.lang.String)
      )(_.error)
      .optionallyWith(
        cause.map(value => SensitiveCause.unwrap(value): java.lang.String)
      )(_.cause)
      .optionallyWith(
        input.map(value => SensitiveData.unwrap(value): java.lang.String)
      )(_.input)
      .optionallyWith(inputDetails.map(value => value.buildAwsValue()))(
        _.inputDetails
      )
      .optionallyWith(
        output.map(value => SensitiveData.unwrap(value): java.lang.String)
      )(_.output)
      .optionallyWith(outputDetails.map(value => value.buildAwsValue()))(
        _.outputDetails
      )
      .optionallyWith(
        traceHeader.map(value => TraceHeader.unwrap(value): java.lang.String)
      )(_.traceHeader)
      .optionallyWith(billingDetails.map(value => value.buildAwsValue()))(
        _.billingDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.StartSyncExecutionResponse.ReadOnly =
    zio.aws.sfn.model.StartSyncExecutionResponse.wrap(buildAwsValue())
}
object StartSyncExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.StartSyncExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.StartSyncExecutionResponse =
      zio.aws.sfn.model.StartSyncExecutionResponse(
        executionArn,
        stateMachineArn.map(value => value),
        name.map(value => value),
        startDate,
        stopDate,
        status,
        error.map(value => value),
        cause.map(value => value),
        input.map(value => value),
        inputDetails.map(value => value.asEditable),
        output.map(value => value),
        outputDetails.map(value => value.asEditable),
        traceHeader.map(value => value),
        billingDetails.map(value => value.asEditable)
      )
    def executionArn: Arn
    def stateMachineArn: Optional[Arn]
    def name: Optional[Name]
    def startDate: Timestamp
    def stopDate: Timestamp
    def status: zio.aws.sfn.model.SyncExecutionStatus
    def error: Optional[SensitiveError]
    def cause: Optional[SensitiveCause]
    def input: Optional[SensitiveData]
    def inputDetails: Optional[
      zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.ReadOnly
    ]
    def output: Optional[SensitiveData]
    def outputDetails: Optional[
      zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.ReadOnly
    ]
    def traceHeader: Optional[TraceHeader]
    def billingDetails: Optional[zio.aws.sfn.model.BillingDetails.ReadOnly]
    def getExecutionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(executionArn)
    def getStateMachineArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("stateMachineArn", stateMachineArn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getStartDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startDate)
    def getStopDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(stopDate)
    def getStatus: ZIO[Any, Nothing, zio.aws.sfn.model.SyncExecutionStatus] =
      ZIO.succeed(status)
    def getError: ZIO[Any, AwsError, SensitiveError] =
      AwsError.unwrapOptionField("error", error)
    def getCause: ZIO[Any, AwsError, SensitiveCause] =
      AwsError.unwrapOptionField("cause", cause)
    def getInput: ZIO[Any, AwsError, SensitiveData] =
      AwsError.unwrapOptionField("input", input)
    def getInputDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.ReadOnly
    ] = AwsError.unwrapOptionField("inputDetails", inputDetails)
    def getOutput: ZIO[Any, AwsError, SensitiveData] =
      AwsError.unwrapOptionField("output", output)
    def getOutputDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.ReadOnly
    ] = AwsError.unwrapOptionField("outputDetails", outputDetails)
    def getTraceHeader: ZIO[Any, AwsError, TraceHeader] =
      AwsError.unwrapOptionField("traceHeader", traceHeader)
    def getBillingDetails
        : ZIO[Any, AwsError, zio.aws.sfn.model.BillingDetails.ReadOnly] =
      AwsError.unwrapOptionField("billingDetails", billingDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.StartSyncExecutionResponse
  ) extends zio.aws.sfn.model.StartSyncExecutionResponse.ReadOnly {
    override val executionArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.executionArn())
    override val stateMachineArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.stateMachineArn())
      .map(value => zio.aws.sfn.model.primitives.Arn(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.sfn.model.primitives.Name(value))
    override val startDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.startDate())
    override val stopDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.stopDate())
    override val status: zio.aws.sfn.model.SyncExecutionStatus =
      zio.aws.sfn.model.SyncExecutionStatus.wrap(impl.status())
    override val error: Optional[SensitiveError] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value => zio.aws.sfn.model.primitives.SensitiveError(value))
    override val cause: Optional[SensitiveCause] = zio.aws.core.internal
      .optionalFromNullable(impl.cause())
      .map(value => zio.aws.sfn.model.primitives.SensitiveCause(value))
    override val input: Optional[SensitiveData] = zio.aws.core.internal
      .optionalFromNullable(impl.input())
      .map(value => zio.aws.sfn.model.primitives.SensitiveData(value))
    override val inputDetails: Optional[
      zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inputDetails())
      .map(value =>
        zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.wrap(value)
      )
    override val output: Optional[SensitiveData] = zio.aws.core.internal
      .optionalFromNullable(impl.output())
      .map(value => zio.aws.sfn.model.primitives.SensitiveData(value))
    override val outputDetails: Optional[
      zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outputDetails())
      .map(value =>
        zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.wrap(value)
      )
    override val traceHeader: Optional[TraceHeader] = zio.aws.core.internal
      .optionalFromNullable(impl.traceHeader())
      .map(value => zio.aws.sfn.model.primitives.TraceHeader(value))
    override val billingDetails
        : Optional[zio.aws.sfn.model.BillingDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billingDetails())
        .map(value => zio.aws.sfn.model.BillingDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.StartSyncExecutionResponse
  ): zio.aws.sfn.model.StartSyncExecutionResponse.ReadOnly = new Wrapper(impl)
}
