package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{SensitiveData, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StateEnteredEventDetails(
    name: Name,
    input: Optional[SensitiveData] = Optional.Absent,
    inputDetails: Optional[zio.aws.sfn.model.HistoryEventExecutionDataDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.StateEnteredEventDetails = {
    import StateEnteredEventDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.StateEnteredEventDetails
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        input.map(value => SensitiveData.unwrap(value): java.lang.String)
      )(_.input)
      .optionallyWith(inputDetails.map(value => value.buildAwsValue()))(
        _.inputDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.StateEnteredEventDetails.ReadOnly =
    zio.aws.sfn.model.StateEnteredEventDetails.wrap(buildAwsValue())
}
object StateEnteredEventDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.StateEnteredEventDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.StateEnteredEventDetails =
      zio.aws.sfn.model.StateEnteredEventDetails(
        name,
        input.map(value => value),
        inputDetails.map(value => value.asEditable)
      )
    def name: Name
    def input: Optional[SensitiveData]
    def inputDetails
        : Optional[zio.aws.sfn.model.HistoryEventExecutionDataDetails.ReadOnly]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getInput: ZIO[Any, AwsError, SensitiveData] =
      AwsError.unwrapOptionField("input", input)
    def getInputDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.HistoryEventExecutionDataDetails.ReadOnly
    ] = AwsError.unwrapOptionField("inputDetails", inputDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.StateEnteredEventDetails
  ) extends zio.aws.sfn.model.StateEnteredEventDetails.ReadOnly {
    override val name: Name = zio.aws.sfn.model.primitives.Name(impl.name())
    override val input: Optional[SensitiveData] = zio.aws.core.internal
      .optionalFromNullable(impl.input())
      .map(value => zio.aws.sfn.model.primitives.SensitiveData(value))
    override val inputDetails: Optional[
      zio.aws.sfn.model.HistoryEventExecutionDataDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inputDetails())
      .map(value =>
        zio.aws.sfn.model.HistoryEventExecutionDataDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.StateEnteredEventDetails
  ): zio.aws.sfn.model.StateEnteredEventDetails.ReadOnly = new Wrapper(impl)
}
