package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{SensitiveData, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StateExitedEventDetails(
    name: Name,
    output: Optional[SensitiveData] = Optional.Absent,
    outputDetails: Optional[
      zio.aws.sfn.model.HistoryEventExecutionDataDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.StateExitedEventDetails = {
    import StateExitedEventDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.StateExitedEventDetails
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        output.map(value => SensitiveData.unwrap(value): java.lang.String)
      )(_.output)
      .optionallyWith(outputDetails.map(value => value.buildAwsValue()))(
        _.outputDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.StateExitedEventDetails.ReadOnly =
    zio.aws.sfn.model.StateExitedEventDetails.wrap(buildAwsValue())
}
object StateExitedEventDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.StateExitedEventDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.StateExitedEventDetails =
      zio.aws.sfn.model.StateExitedEventDetails(
        name,
        output.map(value => value),
        outputDetails.map(value => value.asEditable)
      )
    def name: Name
    def output: Optional[SensitiveData]
    def outputDetails
        : Optional[zio.aws.sfn.model.HistoryEventExecutionDataDetails.ReadOnly]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getOutput: ZIO[Any, AwsError, SensitiveData] =
      AwsError.unwrapOptionField("output", output)
    def getOutputDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.HistoryEventExecutionDataDetails.ReadOnly
    ] = AwsError.unwrapOptionField("outputDetails", outputDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.StateExitedEventDetails
  ) extends zio.aws.sfn.model.StateExitedEventDetails.ReadOnly {
    override val name: Name = zio.aws.sfn.model.primitives.Name(impl.name())
    override val output: Optional[SensitiveData] = zio.aws.core.internal
      .optionalFromNullable(impl.output())
      .map(value => zio.aws.sfn.model.primitives.SensitiveData(value))
    override val outputDetails: Optional[
      zio.aws.sfn.model.HistoryEventExecutionDataDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outputDetails())
      .map(value =>
        zio.aws.sfn.model.HistoryEventExecutionDataDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.StateExitedEventDetails
  ): zio.aws.sfn.model.StateExitedEventDetails.ReadOnly = new Wrapper(impl)
}
