package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{Timestamp, LongArn}
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StateMachineAliasListItem(
    stateMachineAliasArn: LongArn,
    creationDate: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.StateMachineAliasListItem = {
    import StateMachineAliasListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.StateMachineAliasListItem
      .builder()
      .stateMachineAliasArn(
        LongArn.unwrap(stateMachineAliasArn): java.lang.String
      )
      .creationDate(Timestamp.unwrap(creationDate): Instant)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.StateMachineAliasListItem.ReadOnly =
    zio.aws.sfn.model.StateMachineAliasListItem.wrap(buildAwsValue())
}
object StateMachineAliasListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.StateMachineAliasListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.StateMachineAliasListItem =
      zio.aws.sfn.model
        .StateMachineAliasListItem(stateMachineAliasArn, creationDate)
    def stateMachineAliasArn: LongArn
    def creationDate: Timestamp
    def getStateMachineAliasArn: ZIO[Any, Nothing, LongArn] =
      ZIO.succeed(stateMachineAliasArn)
    def getCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.StateMachineAliasListItem
  ) extends zio.aws.sfn.model.StateMachineAliasListItem.ReadOnly {
    override val stateMachineAliasArn: LongArn =
      zio.aws.sfn.model.primitives.LongArn(impl.stateMachineAliasArn())
    override val creationDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.creationDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.StateMachineAliasListItem
  ): zio.aws.sfn.model.StateMachineAliasListItem.ReadOnly = new Wrapper(impl)
}
