package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{Timestamp, Name, Arn}
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StateMachineListItem(
    stateMachineArn: Arn,
    name: Name,
    `type`: zio.aws.sfn.model.StateMachineType,
    creationDate: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.StateMachineListItem = {
    import StateMachineListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.StateMachineListItem
      .builder()
      .stateMachineArn(Arn.unwrap(stateMachineArn): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .creationDate(Timestamp.unwrap(creationDate): Instant)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.StateMachineListItem.ReadOnly =
    zio.aws.sfn.model.StateMachineListItem.wrap(buildAwsValue())
}
object StateMachineListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.StateMachineListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.StateMachineListItem = zio.aws.sfn.model
      .StateMachineListItem(stateMachineArn, name, `type`, creationDate)
    def stateMachineArn: Arn
    def name: Name
    def `type`: zio.aws.sfn.model.StateMachineType
    def creationDate: Timestamp
    def getStateMachineArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(stateMachineArn)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, zio.aws.sfn.model.StateMachineType] =
      ZIO.succeed(`type`)
    def getCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.StateMachineListItem
  ) extends zio.aws.sfn.model.StateMachineListItem.ReadOnly {
    override val stateMachineArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.stateMachineArn())
    override val name: Name = zio.aws.sfn.model.primitives.Name(impl.name())
    override val `type`: zio.aws.sfn.model.StateMachineType =
      zio.aws.sfn.model.StateMachineType.wrap(impl.`type`())
    override val creationDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.creationDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.StateMachineListItem
  ): zio.aws.sfn.model.StateMachineListItem.ReadOnly = new Wrapper(impl)
}
