package zio.aws.sfn.model
import scala.jdk.CollectionConverters._
sealed trait StateMachineStatus {
  def unwrap: software.amazon.awssdk.services.sfn.model.StateMachineStatus
}
object StateMachineStatus {
  def wrap(
      value: software.amazon.awssdk.services.sfn.model.StateMachineStatus
  ): zio.aws.sfn.model.StateMachineStatus = value match {
    case software.amazon.awssdk.services.sfn.model.StateMachineStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sfn.model.StateMachineStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.sfn.model.StateMachineStatus.DELETING =>
      val r = DELETING
      r
  }
  case object unknownToSdkVersion extends zio.aws.sfn.model.StateMachineStatus {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.StateMachineStatus =
      software.amazon.awssdk.services.sfn.model.StateMachineStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.sfn.model.StateMachineStatus {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.StateMachineStatus =
      software.amazon.awssdk.services.sfn.model.StateMachineStatus.ACTIVE
  }
  case object DELETING extends zio.aws.sfn.model.StateMachineStatus {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.StateMachineStatus =
      software.amazon.awssdk.services.sfn.model.StateMachineStatus.DELETING
  }
}
