package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{Timestamp, LongArn}
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StateMachineVersionListItem(
    stateMachineVersionArn: LongArn,
    creationDate: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.StateMachineVersionListItem = {
    import StateMachineVersionListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.StateMachineVersionListItem
      .builder()
      .stateMachineVersionArn(
        LongArn.unwrap(stateMachineVersionArn): java.lang.String
      )
      .creationDate(Timestamp.unwrap(creationDate): Instant)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.StateMachineVersionListItem.ReadOnly =
    zio.aws.sfn.model.StateMachineVersionListItem.wrap(buildAwsValue())
}
object StateMachineVersionListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.StateMachineVersionListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.StateMachineVersionListItem =
      zio.aws.sfn.model
        .StateMachineVersionListItem(stateMachineVersionArn, creationDate)
    def stateMachineVersionArn: LongArn
    def creationDate: Timestamp
    def getStateMachineVersionArn: ZIO[Any, Nothing, LongArn] =
      ZIO.succeed(stateMachineVersionArn)
    def getCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.StateMachineVersionListItem
  ) extends zio.aws.sfn.model.StateMachineVersionListItem.ReadOnly {
    override val stateMachineVersionArn: LongArn =
      zio.aws.sfn.model.primitives.LongArn(impl.stateMachineVersionArn())
    override val creationDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.creationDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.StateMachineVersionListItem
  ): zio.aws.sfn.model.StateMachineVersionListItem.ReadOnly = new Wrapper(impl)
}
