package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{SensitiveCause, SensitiveError, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StopExecutionRequest(
    executionArn: Arn,
    error: Optional[SensitiveError] = Optional.Absent,
    cause: Optional[SensitiveCause] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.StopExecutionRequest = {
    import StopExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.StopExecutionRequest
      .builder()
      .executionArn(Arn.unwrap(executionArn): java.lang.String)
      .optionallyWith(
        error.map(value => SensitiveError.unwrap(value): java.lang.String)
      )(_.error)
      .optionallyWith(
        cause.map(value => SensitiveCause.unwrap(value): java.lang.String)
      )(_.cause)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.StopExecutionRequest.ReadOnly =
    zio.aws.sfn.model.StopExecutionRequest.wrap(buildAwsValue())
}
object StopExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.StopExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.StopExecutionRequest =
      zio.aws.sfn.model.StopExecutionRequest(
        executionArn,
        error.map(value => value),
        cause.map(value => value)
      )
    def executionArn: Arn
    def error: Optional[SensitiveError]
    def cause: Optional[SensitiveCause]
    def getExecutionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(executionArn)
    def getError: ZIO[Any, AwsError, SensitiveError] =
      AwsError.unwrapOptionField("error", error)
    def getCause: ZIO[Any, AwsError, SensitiveCause] =
      AwsError.unwrapOptionField("cause", cause)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.StopExecutionRequest
  ) extends zio.aws.sfn.model.StopExecutionRequest.ReadOnly {
    override val executionArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.executionArn())
    override val error: Optional[SensitiveError] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value => zio.aws.sfn.model.primitives.SensitiveError(value))
    override val cause: Optional[SensitiveCause] = zio.aws.core.internal
      .optionalFromNullable(impl.cause())
      .map(value => zio.aws.sfn.model.primitives.SensitiveCause(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.StopExecutionRequest
  ): zio.aws.sfn.model.StopExecutionRequest.ReadOnly = new Wrapper(impl)
}
