package zio.aws.sfn.model
import scala.jdk.CollectionConverters._
sealed trait SyncExecutionStatus {
  def unwrap: software.amazon.awssdk.services.sfn.model.SyncExecutionStatus
}
object SyncExecutionStatus {
  def wrap(
      value: software.amazon.awssdk.services.sfn.model.SyncExecutionStatus
  ): zio.aws.sfn.model.SyncExecutionStatus = value match {
    case software.amazon.awssdk.services.sfn.model.SyncExecutionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sfn.model.SyncExecutionStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.sfn.model.SyncExecutionStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.sfn.model.SyncExecutionStatus.TIMED_OUT =>
      val r = TIMED_OUT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sfn.model.SyncExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.SyncExecutionStatus =
      software.amazon.awssdk.services.sfn.model.SyncExecutionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCEEDED extends zio.aws.sfn.model.SyncExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.SyncExecutionStatus =
      software.amazon.awssdk.services.sfn.model.SyncExecutionStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.sfn.model.SyncExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.SyncExecutionStatus =
      software.amazon.awssdk.services.sfn.model.SyncExecutionStatus.FAILED
  }
  case object TIMED_OUT extends zio.aws.sfn.model.SyncExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.SyncExecutionStatus =
      software.amazon.awssdk.services.sfn.model.SyncExecutionStatus.TIMED_OUT
  }
}
