package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.LongArn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TaskCredentials(roleArn: Optional[LongArn] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.TaskCredentials = {
    import TaskCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.TaskCredentials
      .builder()
      .optionallyWith(
        roleArn.map(value => LongArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.TaskCredentials.ReadOnly =
    zio.aws.sfn.model.TaskCredentials.wrap(buildAwsValue())
}
object TaskCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.TaskCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.TaskCredentials =
      zio.aws.sfn.model.TaskCredentials(roleArn.map(value => value))
    def roleArn: Optional[LongArn]
    def getRoleArn: ZIO[Any, AwsError, LongArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.TaskCredentials
  ) extends zio.aws.sfn.model.TaskCredentials.ReadOnly {
    override val roleArn: Optional[LongArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.sfn.model.primitives.LongArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.TaskCredentials
  ): zio.aws.sfn.model.TaskCredentials.ReadOnly = new Wrapper(impl)
}
