package zio.aws.sfn.model
import scala.jdk.CollectionConverters._
sealed trait TestExecutionStatus {
  def unwrap: software.amazon.awssdk.services.sfn.model.TestExecutionStatus
}
object TestExecutionStatus {
  def wrap(
      value: software.amazon.awssdk.services.sfn.model.TestExecutionStatus
  ): zio.aws.sfn.model.TestExecutionStatus = value match {
    case software.amazon.awssdk.services.sfn.model.TestExecutionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sfn.model.TestExecutionStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.sfn.model.TestExecutionStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.sfn.model.TestExecutionStatus.RETRIABLE =>
      val r = RETRIABLE
      r
    case software.amazon.awssdk.services.sfn.model.TestExecutionStatus.CAUGHT_ERROR =>
      val r = CAUGHT_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sfn.model.TestExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.TestExecutionStatus =
      software.amazon.awssdk.services.sfn.model.TestExecutionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCEEDED extends zio.aws.sfn.model.TestExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.TestExecutionStatus =
      software.amazon.awssdk.services.sfn.model.TestExecutionStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.sfn.model.TestExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.TestExecutionStatus =
      software.amazon.awssdk.services.sfn.model.TestExecutionStatus.FAILED
  }
  case object RETRIABLE extends zio.aws.sfn.model.TestExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.TestExecutionStatus =
      software.amazon.awssdk.services.sfn.model.TestExecutionStatus.RETRIABLE
  }
  case object CAUGHT_ERROR extends zio.aws.sfn.model.TestExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.TestExecutionStatus =
      software.amazon.awssdk.services.sfn.model.TestExecutionStatus.CAUGHT_ERROR
  }
}
