package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{
  RevealSecrets,
  SensitiveData,
  Arn,
  Definition
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TestStateRequest(
    definition: Definition,
    roleArn: Arn,
    input: Optional[SensitiveData] = Optional.Absent,
    inspectionLevel: Optional[zio.aws.sfn.model.InspectionLevel] =
      Optional.Absent,
    revealSecrets: Optional[RevealSecrets] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.TestStateRequest = {
    import TestStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.TestStateRequest
      .builder()
      .definition(Definition.unwrap(definition): java.lang.String)
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        input.map(value => SensitiveData.unwrap(value): java.lang.String)
      )(_.input)
      .optionallyWith(inspectionLevel.map(value => value.unwrap))(
        _.inspectionLevel
      )
      .optionallyWith(
        revealSecrets.map(value =>
          RevealSecrets.unwrap(value): java.lang.Boolean
        )
      )(_.revealSecrets)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.TestStateRequest.ReadOnly =
    zio.aws.sfn.model.TestStateRequest.wrap(buildAwsValue())
}
object TestStateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.TestStateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.TestStateRequest =
      zio.aws.sfn.model.TestStateRequest(
        definition,
        roleArn,
        input.map(value => value),
        inspectionLevel.map(value => value),
        revealSecrets.map(value => value)
      )
    def definition: Definition
    def roleArn: Arn
    def input: Optional[SensitiveData]
    def inspectionLevel: Optional[zio.aws.sfn.model.InspectionLevel]
    def revealSecrets: Optional[RevealSecrets]
    def getDefinition: ZIO[Any, Nothing, Definition] = ZIO.succeed(definition)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getInput: ZIO[Any, AwsError, SensitiveData] =
      AwsError.unwrapOptionField("input", input)
    def getInspectionLevel
        : ZIO[Any, AwsError, zio.aws.sfn.model.InspectionLevel] =
      AwsError.unwrapOptionField("inspectionLevel", inspectionLevel)
    def getRevealSecrets: ZIO[Any, AwsError, RevealSecrets] =
      AwsError.unwrapOptionField("revealSecrets", revealSecrets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.TestStateRequest
  ) extends zio.aws.sfn.model.TestStateRequest.ReadOnly {
    override val definition: Definition =
      zio.aws.sfn.model.primitives.Definition(impl.definition())
    override val roleArn: Arn = zio.aws.sfn.model.primitives.Arn(impl.roleArn())
    override val input: Optional[SensitiveData] = zio.aws.core.internal
      .optionalFromNullable(impl.input())
      .map(value => zio.aws.sfn.model.primitives.SensitiveData(value))
    override val inspectionLevel: Optional[zio.aws.sfn.model.InspectionLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inspectionLevel())
        .map(value => zio.aws.sfn.model.InspectionLevel.wrap(value))
    override val revealSecrets: Optional[RevealSecrets] = zio.aws.core.internal
      .optionalFromNullable(impl.revealSecrets())
      .map(value => zio.aws.sfn.model.primitives.RevealSecrets(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.TestStateRequest
  ): zio.aws.sfn.model.TestStateRequest.ReadOnly = new Wrapper(impl)
}
