package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{
  StateName,
  SensitiveCause,
  SensitiveError,
  SensitiveData
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TestStateResponse(
    output: Optional[SensitiveData] = Optional.Absent,
    error: Optional[SensitiveError] = Optional.Absent,
    cause: Optional[SensitiveCause] = Optional.Absent,
    inspectionData: Optional[zio.aws.sfn.model.InspectionData] =
      Optional.Absent,
    nextState: Optional[StateName] = Optional.Absent,
    status: Optional[zio.aws.sfn.model.TestExecutionStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.TestStateResponse = {
    import TestStateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.TestStateResponse
      .builder()
      .optionallyWith(
        output.map(value => SensitiveData.unwrap(value): java.lang.String)
      )(_.output)
      .optionallyWith(
        error.map(value => SensitiveError.unwrap(value): java.lang.String)
      )(_.error)
      .optionallyWith(
        cause.map(value => SensitiveCause.unwrap(value): java.lang.String)
      )(_.cause)
      .optionallyWith(inspectionData.map(value => value.buildAwsValue()))(
        _.inspectionData
      )
      .optionallyWith(
        nextState.map(value => StateName.unwrap(value): java.lang.String)
      )(_.nextState)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.TestStateResponse.ReadOnly =
    zio.aws.sfn.model.TestStateResponse.wrap(buildAwsValue())
}
object TestStateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.TestStateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.TestStateResponse =
      zio.aws.sfn.model.TestStateResponse(
        output.map(value => value),
        error.map(value => value),
        cause.map(value => value),
        inspectionData.map(value => value.asEditable),
        nextState.map(value => value),
        status.map(value => value)
      )
    def output: Optional[SensitiveData]
    def error: Optional[SensitiveError]
    def cause: Optional[SensitiveCause]
    def inspectionData: Optional[zio.aws.sfn.model.InspectionData.ReadOnly]
    def nextState: Optional[StateName]
    def status: Optional[zio.aws.sfn.model.TestExecutionStatus]
    def getOutput: ZIO[Any, AwsError, SensitiveData] =
      AwsError.unwrapOptionField("output", output)
    def getError: ZIO[Any, AwsError, SensitiveError] =
      AwsError.unwrapOptionField("error", error)
    def getCause: ZIO[Any, AwsError, SensitiveCause] =
      AwsError.unwrapOptionField("cause", cause)
    def getInspectionData
        : ZIO[Any, AwsError, zio.aws.sfn.model.InspectionData.ReadOnly] =
      AwsError.unwrapOptionField("inspectionData", inspectionData)
    def getNextState: ZIO[Any, AwsError, StateName] =
      AwsError.unwrapOptionField("nextState", nextState)
    def getStatus: ZIO[Any, AwsError, zio.aws.sfn.model.TestExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.TestStateResponse
  ) extends zio.aws.sfn.model.TestStateResponse.ReadOnly {
    override val output: Optional[SensitiveData] = zio.aws.core.internal
      .optionalFromNullable(impl.output())
      .map(value => zio.aws.sfn.model.primitives.SensitiveData(value))
    override val error: Optional[SensitiveError] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value => zio.aws.sfn.model.primitives.SensitiveError(value))
    override val cause: Optional[SensitiveCause] = zio.aws.core.internal
      .optionalFromNullable(impl.cause())
      .map(value => zio.aws.sfn.model.primitives.SensitiveCause(value))
    override val inspectionData
        : Optional[zio.aws.sfn.model.InspectionData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inspectionData())
        .map(value => zio.aws.sfn.model.InspectionData.wrap(value))
    override val nextState: Optional[StateName] = zio.aws.core.internal
      .optionalFromNullable(impl.nextState())
      .map(value => zio.aws.sfn.model.primitives.StateName(value))
    override val status: Optional[zio.aws.sfn.model.TestExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sfn.model.TestExecutionStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.TestStateResponse
  ): zio.aws.sfn.model.TestStateResponse.ReadOnly = new Wrapper(impl)
}
