package zio.aws.sfn.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.{
  ToleratedFailureCount,
  ToleratedFailurePercentage,
  MaxConcurrency,
  LongArn
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateMapRunRequest(
    mapRunArn: LongArn,
    maxConcurrency: Optional[MaxConcurrency] = Optional.Absent,
    toleratedFailurePercentage: Optional[ToleratedFailurePercentage] =
      Optional.Absent,
    toleratedFailureCount: Optional[ToleratedFailureCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.UpdateMapRunRequest = {
    import UpdateMapRunRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.UpdateMapRunRequest
      .builder()
      .mapRunArn(LongArn.unwrap(mapRunArn): java.lang.String)
      .optionallyWith(
        maxConcurrency.map(value => MaxConcurrency.unwrap(value): Integer)
      )(_.maxConcurrency)
      .optionallyWith(
        toleratedFailurePercentage.map(value =>
          ToleratedFailurePercentage.unwrap(value): java.lang.Float
        )
      )(_.toleratedFailurePercentage)
      .optionallyWith(
        toleratedFailureCount.map(value =>
          ToleratedFailureCount.unwrap(value): java.lang.Long
        )
      )(_.toleratedFailureCount)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.UpdateMapRunRequest.ReadOnly =
    zio.aws.sfn.model.UpdateMapRunRequest.wrap(buildAwsValue())
}
object UpdateMapRunRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.UpdateMapRunRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.UpdateMapRunRequest =
      zio.aws.sfn.model.UpdateMapRunRequest(
        mapRunArn,
        maxConcurrency.map(value => value),
        toleratedFailurePercentage.map(value => value),
        toleratedFailureCount.map(value => value)
      )
    def mapRunArn: LongArn
    def maxConcurrency: Optional[MaxConcurrency]
    def toleratedFailurePercentage: Optional[ToleratedFailurePercentage]
    def toleratedFailureCount: Optional[ToleratedFailureCount]
    def getMapRunArn: ZIO[Any, Nothing, LongArn] = ZIO.succeed(mapRunArn)
    def getMaxConcurrency: ZIO[Any, AwsError, MaxConcurrency] =
      AwsError.unwrapOptionField("maxConcurrency", maxConcurrency)
    def getToleratedFailurePercentage
        : ZIO[Any, AwsError, ToleratedFailurePercentage] =
      AwsError.unwrapOptionField(
        "toleratedFailurePercentage",
        toleratedFailurePercentage
      )
    def getToleratedFailureCount: ZIO[Any, AwsError, ToleratedFailureCount] =
      AwsError.unwrapOptionField("toleratedFailureCount", toleratedFailureCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.UpdateMapRunRequest
  ) extends zio.aws.sfn.model.UpdateMapRunRequest.ReadOnly {
    override val mapRunArn: LongArn =
      zio.aws.sfn.model.primitives.LongArn(impl.mapRunArn())
    override val maxConcurrency: Optional[MaxConcurrency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxConcurrency())
        .map(value => zio.aws.sfn.model.primitives.MaxConcurrency(value))
    override val toleratedFailurePercentage
        : Optional[ToleratedFailurePercentage] = zio.aws.core.internal
      .optionalFromNullable(impl.toleratedFailurePercentage())
      .map(value =>
        zio.aws.sfn.model.primitives.ToleratedFailurePercentage(value)
      )
    override val toleratedFailureCount: Optional[ToleratedFailureCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.toleratedFailureCount())
        .map(value => zio.aws.sfn.model.primitives.ToleratedFailureCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.UpdateMapRunRequest
  ): zio.aws.sfn.model.UpdateMapRunRequest.ReadOnly = new Wrapper(impl)
}
