package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{AliasDescription, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateStateMachineAliasRequest(
    stateMachineAliasArn: Arn,
    description: Optional[AliasDescription] = Optional.Absent,
    routingConfiguration: Optional[
      Iterable[zio.aws.sfn.model.RoutingConfigurationListItem]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.UpdateStateMachineAliasRequest = {
    import UpdateStateMachineAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.UpdateStateMachineAliasRequest
      .builder()
      .stateMachineAliasArn(Arn.unwrap(stateMachineAliasArn): java.lang.String)
      .optionallyWith(
        description.map(value =>
          AliasDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        routingConfiguration.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routingConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.UpdateStateMachineAliasRequest.ReadOnly =
    zio.aws.sfn.model.UpdateStateMachineAliasRequest.wrap(buildAwsValue())
}
object UpdateStateMachineAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.UpdateStateMachineAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.UpdateStateMachineAliasRequest =
      zio.aws.sfn.model.UpdateStateMachineAliasRequest(
        stateMachineAliasArn,
        description.map(value => value),
        routingConfiguration.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def stateMachineAliasArn: Arn
    def description: Optional[AliasDescription]
    def routingConfiguration: Optional[
      List[zio.aws.sfn.model.RoutingConfigurationListItem.ReadOnly]
    ]
    def getStateMachineAliasArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(stateMachineAliasArn)
    def getDescription: ZIO[Any, AwsError, AliasDescription] =
      AwsError.unwrapOptionField("description", description)
    def getRoutingConfiguration: ZIO[Any, AwsError, List[
      zio.aws.sfn.model.RoutingConfigurationListItem.ReadOnly
    ]] =
      AwsError.unwrapOptionField("routingConfiguration", routingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.UpdateStateMachineAliasRequest
  ) extends zio.aws.sfn.model.UpdateStateMachineAliasRequest.ReadOnly {
    override val stateMachineAliasArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.stateMachineAliasArn())
    override val description: Optional[AliasDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.sfn.model.primitives.AliasDescription(value))
    override val routingConfiguration: Optional[
      List[zio.aws.sfn.model.RoutingConfigurationListItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.routingConfiguration())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sfn.model.RoutingConfigurationListItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.UpdateStateMachineAliasRequest
  ): zio.aws.sfn.model.UpdateStateMachineAliasRequest.ReadOnly = new Wrapper(
    impl
  )
}
