package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.Timestamp
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class UpdateStateMachineAliasResponse(updateDate: Timestamp) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.UpdateStateMachineAliasResponse = {
    import UpdateStateMachineAliasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.UpdateStateMachineAliasResponse
      .builder()
      .updateDate(Timestamp.unwrap(updateDate): Instant)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.UpdateStateMachineAliasResponse.ReadOnly =
    zio.aws.sfn.model.UpdateStateMachineAliasResponse.wrap(buildAwsValue())
}
object UpdateStateMachineAliasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.UpdateStateMachineAliasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.UpdateStateMachineAliasResponse =
      zio.aws.sfn.model.UpdateStateMachineAliasResponse(updateDate)
    def updateDate: Timestamp
    def getUpdateDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.UpdateStateMachineAliasResponse
  ) extends zio.aws.sfn.model.UpdateStateMachineAliasResponse.ReadOnly {
    override val updateDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.updateDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.UpdateStateMachineAliasResponse
  ): zio.aws.sfn.model.UpdateStateMachineAliasResponse.ReadOnly = new Wrapper(
    impl
  )
}
