package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{
  VersionDescription,
  Publish,
  Definition,
  Arn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateStateMachineRequest(
    stateMachineArn: Arn,
    definition: Optional[Definition] = Optional.Absent,
    roleArn: Optional[Arn] = Optional.Absent,
    loggingConfiguration: Optional[zio.aws.sfn.model.LoggingConfiguration] =
      Optional.Absent,
    tracingConfiguration: Optional[zio.aws.sfn.model.TracingConfiguration] =
      Optional.Absent,
    publish: Optional[Publish] = Optional.Absent,
    versionDescription: Optional[VersionDescription] = Optional.Absent,
    encryptionConfiguration: Optional[
      zio.aws.sfn.model.EncryptionConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.UpdateStateMachineRequest = {
    import UpdateStateMachineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.UpdateStateMachineRequest
      .builder()
      .stateMachineArn(Arn.unwrap(stateMachineArn): java.lang.String)
      .optionallyWith(
        definition.map(value => Definition.unwrap(value): java.lang.String)
      )(_.definition)
      .optionallyWith(
        roleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(loggingConfiguration.map(value => value.buildAwsValue()))(
        _.loggingConfiguration
      )
      .optionallyWith(tracingConfiguration.map(value => value.buildAwsValue()))(
        _.tracingConfiguration
      )
      .optionallyWith(
        publish.map(value => Publish.unwrap(value): java.lang.Boolean)
      )(_.publish)
      .optionallyWith(
        versionDescription.map(value =>
          VersionDescription.unwrap(value): java.lang.String
        )
      )(_.versionDescription)
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.UpdateStateMachineRequest.ReadOnly =
    zio.aws.sfn.model.UpdateStateMachineRequest.wrap(buildAwsValue())
}
object UpdateStateMachineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.UpdateStateMachineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.UpdateStateMachineRequest =
      zio.aws.sfn.model.UpdateStateMachineRequest(
        stateMachineArn,
        definition.map(value => value),
        roleArn.map(value => value),
        loggingConfiguration.map(value => value.asEditable),
        tracingConfiguration.map(value => value.asEditable),
        publish.map(value => value),
        versionDescription.map(value => value),
        encryptionConfiguration.map(value => value.asEditable)
      )
    def stateMachineArn: Arn
    def definition: Optional[Definition]
    def roleArn: Optional[Arn]
    def loggingConfiguration
        : Optional[zio.aws.sfn.model.LoggingConfiguration.ReadOnly]
    def tracingConfiguration
        : Optional[zio.aws.sfn.model.TracingConfiguration.ReadOnly]
    def publish: Optional[Publish]
    def versionDescription: Optional[VersionDescription]
    def encryptionConfiguration
        : Optional[zio.aws.sfn.model.EncryptionConfiguration.ReadOnly]
    def getStateMachineArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(stateMachineArn)
    def getDefinition: ZIO[Any, AwsError, Definition] =
      AwsError.unwrapOptionField("definition", definition)
    def getRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getLoggingConfiguration
        : ZIO[Any, AwsError, zio.aws.sfn.model.LoggingConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("loggingConfiguration", loggingConfiguration)
    def getTracingConfiguration
        : ZIO[Any, AwsError, zio.aws.sfn.model.TracingConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("tracingConfiguration", tracingConfiguration)
    def getPublish: ZIO[Any, AwsError, Publish] =
      AwsError.unwrapOptionField("publish", publish)
    def getVersionDescription: ZIO[Any, AwsError, VersionDescription] =
      AwsError.unwrapOptionField("versionDescription", versionDescription)
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.EncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.UpdateStateMachineRequest
  ) extends zio.aws.sfn.model.UpdateStateMachineRequest.ReadOnly {
    override val stateMachineArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.stateMachineArn())
    override val definition: Optional[Definition] = zio.aws.core.internal
      .optionalFromNullable(impl.definition())
      .map(value => zio.aws.sfn.model.primitives.Definition(value))
    override val roleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.sfn.model.primitives.Arn(value))
    override val loggingConfiguration
        : Optional[zio.aws.sfn.model.LoggingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loggingConfiguration())
        .map(value => zio.aws.sfn.model.LoggingConfiguration.wrap(value))
    override val tracingConfiguration
        : Optional[zio.aws.sfn.model.TracingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tracingConfiguration())
        .map(value => zio.aws.sfn.model.TracingConfiguration.wrap(value))
    override val publish: Optional[Publish] = zio.aws.core.internal
      .optionalFromNullable(impl.publish())
      .map(value => zio.aws.sfn.model.primitives.Publish(value))
    override val versionDescription: Optional[VersionDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionDescription())
        .map(value => zio.aws.sfn.model.primitives.VersionDescription(value))
    override val encryptionConfiguration
        : Optional[zio.aws.sfn.model.EncryptionConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionConfiguration())
        .map(value => zio.aws.sfn.model.EncryptionConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.UpdateStateMachineRequest
  ): zio.aws.sfn.model.UpdateStateMachineRequest.ReadOnly = new Wrapper(impl)
}
