package zio.aws.sfn.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.{Arn, RevisionId, Timestamp}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class UpdateStateMachineResponse(
    updateDate: Timestamp,
    revisionId: Optional[RevisionId] = Optional.Absent,
    stateMachineVersionArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.UpdateStateMachineResponse = {
    import UpdateStateMachineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.UpdateStateMachineResponse
      .builder()
      .updateDate(Timestamp.unwrap(updateDate): Instant)
      .optionallyWith(
        revisionId.map(value => RevisionId.unwrap(value): java.lang.String)
      )(_.revisionId)
      .optionallyWith(
        stateMachineVersionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.stateMachineVersionArn)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.UpdateStateMachineResponse.ReadOnly =
    zio.aws.sfn.model.UpdateStateMachineResponse.wrap(buildAwsValue())
}
object UpdateStateMachineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.UpdateStateMachineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.UpdateStateMachineResponse =
      zio.aws.sfn.model.UpdateStateMachineResponse(
        updateDate,
        revisionId.map(value => value),
        stateMachineVersionArn.map(value => value)
      )
    def updateDate: Timestamp
    def revisionId: Optional[RevisionId]
    def stateMachineVersionArn: Optional[Arn]
    def getUpdateDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateDate)
    def getRevisionId: ZIO[Any, AwsError, RevisionId] =
      AwsError.unwrapOptionField("revisionId", revisionId)
    def getStateMachineVersionArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("stateMachineVersionArn", stateMachineVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.UpdateStateMachineResponse
  ) extends zio.aws.sfn.model.UpdateStateMachineResponse.ReadOnly {
    override val updateDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.updateDate())
    override val revisionId: Optional[RevisionId] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionId())
      .map(value => zio.aws.sfn.model.primitives.RevisionId(value))
    override val stateMachineVersionArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.stateMachineVersionArn())
      .map(value => zio.aws.sfn.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.UpdateStateMachineResponse
  ): zio.aws.sfn.model.UpdateStateMachineResponse.ReadOnly = new Wrapper(impl)
}
