package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{
  ValidateStateMachineDefinitionLocation,
  ValidateStateMachineDefinitionMessage,
  ValidateStateMachineDefinitionCode
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ValidateStateMachineDefinitionDiagnostic(
    severity: zio.aws.sfn.model.ValidateStateMachineDefinitionSeverity,
    code: ValidateStateMachineDefinitionCode,
    message: ValidateStateMachineDefinitionMessage,
    location: Optional[ValidateStateMachineDefinitionLocation] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionDiagnostic = {
    import ValidateStateMachineDefinitionDiagnostic.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionDiagnostic
      .builder()
      .severity(severity.unwrap)
      .code(ValidateStateMachineDefinitionCode.unwrap(code): java.lang.String)
      .message(
        ValidateStateMachineDefinitionMessage.unwrap(message): java.lang.String
      )
      .optionallyWith(
        location.map(value =>
          ValidateStateMachineDefinitionLocation.unwrap(value): java.lang.String
        )
      )(_.location)
      .build()
  }
  def asReadOnly
      : zio.aws.sfn.model.ValidateStateMachineDefinitionDiagnostic.ReadOnly =
    zio.aws.sfn.model.ValidateStateMachineDefinitionDiagnostic
      .wrap(buildAwsValue())
}
object ValidateStateMachineDefinitionDiagnostic {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionDiagnostic
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.ValidateStateMachineDefinitionDiagnostic =
      zio.aws.sfn.model.ValidateStateMachineDefinitionDiagnostic(
        severity,
        code,
        message,
        location.map(value => value)
      )
    def severity: zio.aws.sfn.model.ValidateStateMachineDefinitionSeverity
    def code: ValidateStateMachineDefinitionCode
    def message: ValidateStateMachineDefinitionMessage
    def location: Optional[ValidateStateMachineDefinitionLocation]
    def getSeverity: ZIO[
      Any,
      Nothing,
      zio.aws.sfn.model.ValidateStateMachineDefinitionSeverity
    ] = ZIO.succeed(severity)
    def getCode: ZIO[Any, Nothing, ValidateStateMachineDefinitionCode] =
      ZIO.succeed(code)
    def getMessage: ZIO[Any, Nothing, ValidateStateMachineDefinitionMessage] =
      ZIO.succeed(message)
    def getLocation
        : ZIO[Any, AwsError, ValidateStateMachineDefinitionLocation] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionDiagnostic
  ) extends zio.aws.sfn.model.ValidateStateMachineDefinitionDiagnostic.ReadOnly {
    override val severity
        : zio.aws.sfn.model.ValidateStateMachineDefinitionSeverity =
      zio.aws.sfn.model.ValidateStateMachineDefinitionSeverity
        .wrap(impl.severity())
    override val code: ValidateStateMachineDefinitionCode =
      zio.aws.sfn.model.primitives
        .ValidateStateMachineDefinitionCode(impl.code())
    override val message: ValidateStateMachineDefinitionMessage =
      zio.aws.sfn.model.primitives
        .ValidateStateMachineDefinitionMessage(impl.message())
    override val location: Optional[ValidateStateMachineDefinitionLocation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value =>
          zio.aws.sfn.model.primitives
            .ValidateStateMachineDefinitionLocation(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionDiagnostic
  ): zio.aws.sfn.model.ValidateStateMachineDefinitionDiagnostic.ReadOnly =
    new Wrapper(impl)
}
