package zio.aws.sfn.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.{
  ValidateStateMachineDefinitionMaxResult,
  Definition
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ValidateStateMachineDefinitionRequest(
    definition: Definition,
    `type`: Optional[zio.aws.sfn.model.StateMachineType] = Optional.Absent,
    severity: Optional[
      zio.aws.sfn.model.ValidateStateMachineDefinitionSeverity
    ] = Optional.Absent,
    maxResults: Optional[ValidateStateMachineDefinitionMaxResult] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionRequest = {
    import ValidateStateMachineDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionRequest
      .builder()
      .definition(Definition.unwrap(definition): java.lang.String)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(severity.map(value => value.unwrap))(_.severity)
      .optionallyWith(
        maxResults.map(value =>
          ValidateStateMachineDefinitionMaxResult.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.sfn.model.ValidateStateMachineDefinitionRequest.ReadOnly =
    zio.aws.sfn.model.ValidateStateMachineDefinitionRequest
      .wrap(buildAwsValue())
}
object ValidateStateMachineDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.ValidateStateMachineDefinitionRequest =
      zio.aws.sfn.model.ValidateStateMachineDefinitionRequest(
        definition,
        `type`.map(value => value),
        severity.map(value => value),
        maxResults.map(value => value)
      )
    def definition: Definition
    def `type`: Optional[zio.aws.sfn.model.StateMachineType]
    def severity
        : Optional[zio.aws.sfn.model.ValidateStateMachineDefinitionSeverity]
    def maxResults: Optional[ValidateStateMachineDefinitionMaxResult]
    def getDefinition: ZIO[Any, Nothing, Definition] = ZIO.succeed(definition)
    def getType: ZIO[Any, AwsError, zio.aws.sfn.model.StateMachineType] =
      AwsError.unwrapOptionField("type", `type`)
    def getSeverity: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.ValidateStateMachineDefinitionSeverity
    ] = AwsError.unwrapOptionField("severity", severity)
    def getMaxResults
        : ZIO[Any, AwsError, ValidateStateMachineDefinitionMaxResult] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionRequest
  ) extends zio.aws.sfn.model.ValidateStateMachineDefinitionRequest.ReadOnly {
    override val definition: Definition =
      zio.aws.sfn.model.primitives.Definition(impl.definition())
    override val `type`: Optional[zio.aws.sfn.model.StateMachineType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.sfn.model.StateMachineType.wrap(value))
    override val severity
        : Optional[zio.aws.sfn.model.ValidateStateMachineDefinitionSeverity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severity())
        .map(value =>
          zio.aws.sfn.model.ValidateStateMachineDefinitionSeverity.wrap(value)
        )
    override val maxResults: Optional[ValidateStateMachineDefinitionMaxResult] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.sfn.model.primitives
            .ValidateStateMachineDefinitionMaxResult(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionRequest
  ): zio.aws.sfn.model.ValidateStateMachineDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
