package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.ValidateStateMachineDefinitionTruncated
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ValidateStateMachineDefinitionResponse(
    result: zio.aws.sfn.model.ValidateStateMachineDefinitionResultCode,
    diagnostics: Iterable[
      zio.aws.sfn.model.ValidateStateMachineDefinitionDiagnostic
    ],
    truncated: Optional[ValidateStateMachineDefinitionTruncated] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionResponse = {
    import ValidateStateMachineDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionResponse
      .builder()
      .result(result.unwrap)
      .diagnostics(diagnostics.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        truncated.map(value =>
          ValidateStateMachineDefinitionTruncated.unwrap(
            value
          ): java.lang.Boolean
        )
      )(_.truncated)
      .build()
  }
  def asReadOnly
      : zio.aws.sfn.model.ValidateStateMachineDefinitionResponse.ReadOnly =
    zio.aws.sfn.model.ValidateStateMachineDefinitionResponse
      .wrap(buildAwsValue())
}
object ValidateStateMachineDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.ValidateStateMachineDefinitionResponse =
      zio.aws.sfn.model.ValidateStateMachineDefinitionResponse(
        result,
        diagnostics.map { item =>
          item.asEditable
        },
        truncated.map(value => value)
      )
    def result: zio.aws.sfn.model.ValidateStateMachineDefinitionResultCode
    def diagnostics: List[
      zio.aws.sfn.model.ValidateStateMachineDefinitionDiagnostic.ReadOnly
    ]
    def truncated: Optional[ValidateStateMachineDefinitionTruncated]
    def getResult: ZIO[
      Any,
      Nothing,
      zio.aws.sfn.model.ValidateStateMachineDefinitionResultCode
    ] = ZIO.succeed(result)
    def getDiagnostics: ZIO[Any, Nothing, List[
      zio.aws.sfn.model.ValidateStateMachineDefinitionDiagnostic.ReadOnly
    ]] = ZIO.succeed(diagnostics)
    def getTruncated
        : ZIO[Any, AwsError, ValidateStateMachineDefinitionTruncated] =
      AwsError.unwrapOptionField("truncated", truncated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionResponse
  ) extends zio.aws.sfn.model.ValidateStateMachineDefinitionResponse.ReadOnly {
    override val result
        : zio.aws.sfn.model.ValidateStateMachineDefinitionResultCode =
      zio.aws.sfn.model.ValidateStateMachineDefinitionResultCode
        .wrap(impl.result())
    override val diagnostics: List[
      zio.aws.sfn.model.ValidateStateMachineDefinitionDiagnostic.ReadOnly
    ] = impl
      .diagnostics()
      .asScala
      .map { item =>
        zio.aws.sfn.model.ValidateStateMachineDefinitionDiagnostic.wrap(item)
      }
      .toList
    override val truncated: Optional[ValidateStateMachineDefinitionTruncated] =
      zio.aws.core.internal
        .optionalFromNullable(impl.truncated())
        .map(value =>
          zio.aws.sfn.model.primitives
            .ValidateStateMachineDefinitionTruncated(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionResponse
  ): zio.aws.sfn.model.ValidateStateMachineDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
