package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteActivityRequest(activityArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.DeleteActivityRequest = {
    import DeleteActivityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.DeleteActivityRequest
      .builder()
      .activityArn(Arn.unwrap(activityArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.DeleteActivityRequest.ReadOnly =
    zio.aws.sfn.model.DeleteActivityRequest.wrap(buildAwsValue())
}
object DeleteActivityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.DeleteActivityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.DeleteActivityRequest =
      zio.aws.sfn.model.DeleteActivityRequest(activityArn)
    def activityArn: Arn
    def getActivityArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(activityArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.DeleteActivityRequest
  ) extends zio.aws.sfn.model.DeleteActivityRequest.ReadOnly {
    override val activityArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.activityArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.DeleteActivityRequest
  ): zio.aws.sfn.model.DeleteActivityRequest.ReadOnly = new Wrapper(impl)
}
