package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeExecutionRequest(executionArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.DescribeExecutionRequest = {
    import DescribeExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.DescribeExecutionRequest
      .builder()
      .executionArn(Arn.unwrap(executionArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.DescribeExecutionRequest.ReadOnly =
    zio.aws.sfn.model.DescribeExecutionRequest.wrap(buildAwsValue())
}
object DescribeExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.DescribeExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.DescribeExecutionRequest =
      zio.aws.sfn.model.DescribeExecutionRequest(executionArn)
    def executionArn: Arn
    def getExecutionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(executionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.DescribeExecutionRequest
  ) extends zio.aws.sfn.model.DescribeExecutionRequest.ReadOnly {
    override val executionArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.executionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.DescribeExecutionRequest
  ): zio.aws.sfn.model.DescribeExecutionRequest.ReadOnly = new Wrapper(impl)
}
