package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeStateMachineRequest(stateMachineArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.DescribeStateMachineRequest = {
    import DescribeStateMachineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.DescribeStateMachineRequest
      .builder()
      .stateMachineArn(Arn.unwrap(stateMachineArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.DescribeStateMachineRequest.ReadOnly =
    zio.aws.sfn.model.DescribeStateMachineRequest.wrap(buildAwsValue())
}
object DescribeStateMachineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.DescribeStateMachineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.DescribeStateMachineRequest =
      zio.aws.sfn.model.DescribeStateMachineRequest(stateMachineArn)
    def stateMachineArn: Arn
    def getStateMachineArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(stateMachineArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.DescribeStateMachineRequest
  ) extends zio.aws.sfn.model.DescribeStateMachineRequest.ReadOnly {
    override val stateMachineArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.stateMachineArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.DescribeStateMachineRequest
  ): zio.aws.sfn.model.DescribeStateMachineRequest.ReadOnly = new Wrapper(impl)
}
