package zio.aws.sfn.model
import scala.jdk.CollectionConverters.*
sealed trait ExecutionStatus {
  def unwrap: software.amazon.awssdk.services.sfn.model.ExecutionStatus
}
object ExecutionStatus {
  def wrap(
      value: software.amazon.awssdk.services.sfn.model.ExecutionStatus
  ): zio.aws.sfn.model.ExecutionStatus = value match {
    case software.amazon.awssdk.services.sfn.model.ExecutionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sfn.model.ExecutionStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.sfn.model.ExecutionStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.sfn.model.ExecutionStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.sfn.model.ExecutionStatus.TIMED_OUT =>
      val r = TIMED_OUT
      r
    case software.amazon.awssdk.services.sfn.model.ExecutionStatus.ABORTED =>
      val r = ABORTED
      r
  }
  case object unknownToSdkVersion extends zio.aws.sfn.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.ExecutionStatus =
      software.amazon.awssdk.services.sfn.model.ExecutionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object RUNNING extends zio.aws.sfn.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.ExecutionStatus =
      software.amazon.awssdk.services.sfn.model.ExecutionStatus.RUNNING
  }
  case object SUCCEEDED extends zio.aws.sfn.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.ExecutionStatus =
      software.amazon.awssdk.services.sfn.model.ExecutionStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.sfn.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.ExecutionStatus =
      software.amazon.awssdk.services.sfn.model.ExecutionStatus.FAILED
  }
  case object TIMED_OUT extends zio.aws.sfn.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.ExecutionStatus =
      software.amazon.awssdk.services.sfn.model.ExecutionStatus.TIMED_OUT
  }
  case object ABORTED extends zio.aws.sfn.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.ExecutionStatus =
      software.amazon.awssdk.services.sfn.model.ExecutionStatus.ABORTED
  }
}
