package zio.aws.sfn.model
import scala.jdk.CollectionConverters.*
sealed trait LogLevel {
  def unwrap: software.amazon.awssdk.services.sfn.model.LogLevel
}
object LogLevel {
  def wrap(
      value: software.amazon.awssdk.services.sfn.model.LogLevel
  ): zio.aws.sfn.model.LogLevel = value match {
    case software.amazon.awssdk.services.sfn.model.LogLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sfn.model.LogLevel.ALL =>
      val r = ALL
      r
    case software.amazon.awssdk.services.sfn.model.LogLevel.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.sfn.model.LogLevel.FATAL =>
      val r = FATAL
      r
    case software.amazon.awssdk.services.sfn.model.LogLevel.OFF =>
      val r = OFF
      r
  }
  case object unknownToSdkVersion extends zio.aws.sfn.model.LogLevel {
    override def unwrap: software.amazon.awssdk.services.sfn.model.LogLevel =
      software.amazon.awssdk.services.sfn.model.LogLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL extends zio.aws.sfn.model.LogLevel {
    override def unwrap: software.amazon.awssdk.services.sfn.model.LogLevel =
      software.amazon.awssdk.services.sfn.model.LogLevel.ALL
  }
  case object ERROR extends zio.aws.sfn.model.LogLevel {
    override def unwrap: software.amazon.awssdk.services.sfn.model.LogLevel =
      software.amazon.awssdk.services.sfn.model.LogLevel.ERROR
  }
  case object FATAL extends zio.aws.sfn.model.LogLevel {
    override def unwrap: software.amazon.awssdk.services.sfn.model.LogLevel =
      software.amazon.awssdk.services.sfn.model.LogLevel.FATAL
  }
  case object OFF extends zio.aws.sfn.model.LogLevel {
    override def unwrap: software.amazon.awssdk.services.sfn.model.LogLevel =
      software.amazon.awssdk.services.sfn.model.LogLevel.OFF
  }
}
