package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{Timestamp, Arn}
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class StartExecutionResponse(
    executionArn: Arn,
    startDate: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.StartExecutionResponse = {
    import StartExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.StartExecutionResponse
      .builder()
      .executionArn(Arn.unwrap(executionArn): java.lang.String)
      .startDate(Timestamp.unwrap(startDate): Instant)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.StartExecutionResponse.ReadOnly =
    zio.aws.sfn.model.StartExecutionResponse.wrap(buildAwsValue())
}
object StartExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.StartExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.StartExecutionResponse =
      zio.aws.sfn.model.StartExecutionResponse(executionArn, startDate)
    def executionArn: Arn
    def startDate: Timestamp
    def getExecutionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(executionArn)
    def getStartDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.StartExecutionResponse
  ) extends zio.aws.sfn.model.StartExecutionResponse.ReadOnly {
    override val executionArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.executionArn())
    override val startDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.startDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.StartExecutionResponse
  ): zio.aws.sfn.model.StartExecutionResponse.ReadOnly = new Wrapper(impl)
}
