package zio.aws.sfn.model
import scala.jdk.CollectionConverters.*
sealed trait StateMachineType {
  def unwrap: software.amazon.awssdk.services.sfn.model.StateMachineType
}
object StateMachineType {
  def wrap(
      value: software.amazon.awssdk.services.sfn.model.StateMachineType
  ): zio.aws.sfn.model.StateMachineType = value match {
    case software.amazon.awssdk.services.sfn.model.StateMachineType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sfn.model.StateMachineType.STANDARD =>
      val r = STANDARD
      r
    case software.amazon.awssdk.services.sfn.model.StateMachineType.EXPRESS =>
      val r = EXPRESS
      r
  }
  case object unknownToSdkVersion extends zio.aws.sfn.model.StateMachineType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.StateMachineType =
      software.amazon.awssdk.services.sfn.model.StateMachineType.UNKNOWN_TO_SDK_VERSION
  }
  case object STANDARD extends zio.aws.sfn.model.StateMachineType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.StateMachineType =
      software.amazon.awssdk.services.sfn.model.StateMachineType.STANDARD
  }
  case object EXPRESS extends zio.aws.sfn.model.StateMachineType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.StateMachineType =
      software.amazon.awssdk.services.sfn.model.StateMachineType.EXPRESS
  }
}
