package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.Timestamp
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class StopExecutionResponse(stopDate: Timestamp) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.StopExecutionResponse = {
    import StopExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.StopExecutionResponse
      .builder()
      .stopDate(Timestamp.unwrap(stopDate): Instant)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.StopExecutionResponse.ReadOnly =
    zio.aws.sfn.model.StopExecutionResponse.wrap(buildAwsValue())
}
object StopExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.StopExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.StopExecutionResponse =
      zio.aws.sfn.model.StopExecutionResponse(stopDate)
    def stopDate: Timestamp
    def getStopDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(stopDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.StopExecutionResponse
  ) extends zio.aws.sfn.model.StopExecutionResponse.ReadOnly {
    override val stopDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.stopDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.StopExecutionResponse
  ): zio.aws.sfn.model.StopExecutionResponse.ReadOnly = new Wrapper(impl)
}
